<?php 
include_once __DIR__.'/../framework/init.php';

class AcelleWPWorkflowsAdmin {

	public $triggers = [];
	public $actions = [];

	public function __construct()
	{
		// create admin setting page
		$this->apiSettings();
		$this->checkAceMailSettings();

	}
	
	public function allAllUsers()
	{
		$listId = '';
		$all_users = get_users();
		$api_key = wp_get_page_field_value('acellewpemail-settings', 'acellemail_wp_api_key');
		$end_point = wp_get_page_field_value('acellewpemail-settings', 'acellemail_wp_api_endpoint');
		$objAcelle = new AcelleMail($api_key, $end_point);

		if ($all_users) {
			foreach($all_users as $users) {
				$u = $users->data;
				$subscriber = [];
				if ($u->user_nicename) {
					$subscriber['FIRST_NAME'] = $u->user_nicename;
				}
				if ($u->first_name) {
					$subscriber['FIRST_NAME'] = $u->first_name;
				}
				if ($u->last_name) {
					$subscriber['LAST_NAME'] = $u->last_name;
				}
				if ($u->user_email) {
					$subscriber['EMAIL'] = $u->user_email;
				}
				$objAcelle->create_subscriber($listId, $subscriber);
			}
		}
	}

	public function apiSettings()
	{
		$page_args = [
		    'menu_name'         => __('Acellemail WP', 'CAI'),
		    'id'                => 'acellewpemail-settings',
		    'prefix'    => 'CACELLE',

		];
		$acemailSettings = wp_create_admin_page( $page_args );


		$field_args = [
		    'type'      => 'text',
		    'id'        => 'acellemail_wp_api_endpoint',
		    'label'     => __('Acelle Mail API Endpoint', 'CAI'),
		    'desc'      => __('Enter your ACELLE MAIL API Endpoint', 'CAI'),
		    'props'     => [
		        'placeholder' => ''
		    ],
		];
		$acemailSettings->add_field( $field_args );

		$field_args = [
		    'type'      => 'text',
		    'id'        => 'acellemail_wp_api_key',
		    'label'     => __('Acelle Mail API Key', 'CAI'),
		    'desc'      => __('Enter your ACELLE MAIL API Key', 'CAI'),
		    'props'     => [
		        'placeholder' => ''
			],
			
		];

		// creates a text field
		$acemailSettings->add_field( $field_args );

	}

	public function checkAceMailSettings()
	{
		global $wp_settings_errors;
		$api_key = wp_get_page_field_value('acellewpemail-settings', 'acellemail_wp_api_key');
    	$end_point = wp_get_page_field_value('acellewpemail-settings', 'acellemail_wp_api_endpoint');
		$objAcelle = new AcelleMail($api_key, $end_point);
		$lists = $objAcelle->get_all_list();
		if ($api_key && $end_point && isset($lists['error']) && $lists['error'] == 'Unauthenticated.') {
			function error_notice()
			{
				$class = 'notice notice-error';
				$message = __('Invalid API token or endpoint, please check your AcelleMail settings', 'CAI');

				printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
			}
			add_action('admin_notices', 'error_notice');

		}	
		

		

	}


}
